﻿//=============================================================================
// PreOrderQuest.js
//=============================================================================

var Imported = Imported || {};
Imported.PreOrderQuestContent = true;

/*:
 * @plugindesc 受注クエスト一覧を表示するスクリプト
 * 
 * @help
 * プラグインコマンド:
 *
 *   PreOrderQuest list
 *     受注クエスト一覧を表示する。
 *
 *   PreOrderQuest add
 *      変数002 のクエストを追加する。
 *
 *   PreOrderQuest remove
 *      変数002 のクエストを削除する。
 *
 *   PreOrderQuest has 10
 *      クエスト ID 10 を受注しているかどうかを返す。
 *
 *   PreOrderQuest clear
 *      一覧をクリアする。
 */

(function ()
{
    // プラグイン コマンド
    Game_System.prototype.addPreOrderQuest = function (no)
    {
        var value;

        if (!no)
        {
            no = $gameVariables.value(2);
        }

        var index = $gameVariables.value(4) + 116;
        for (var i = 101; i < 111; ++i)
        {
            value = $gameVariables.value(i);
            if (value == -1)
            {
                $gameVariables.setValue(i, no);

                $gameVariables.setValue(index, -1);
                break;
            }
        }

        if (index < 120)
        {
            for (var i = index; i < 120; ++i)
            {
                value = $gameVariables.value(i + 1);

                if (value == -1)
                {
                    break;
                }
                $gameVariables.setValue(i, value);
                $gameVariables.setValue(i + 1, -1);
            }
        }
    };

    Game_System.prototype.removePreOrderQuest = function (no)
    {
        var value, i;

        if (!no)
        {
            no = $gameVariables.value(2);
        }
        for (i = 101; i < 111; ++i)
        {
            value = $gameVariables.value(i);
            if (value == no)
            {
                $gameVariables.setValue(i, -1);
                break;
            }
        }

        if (i < 110)
        {
            for (; i < 110; ++i)
            {
                value = $gameVariables.value(i + 1);

                if (value == -1)
                {
                    break;
                }
                $gameVariables.setValue(i, value);
                $gameVariables.setValue(i + 1, -1);
            }
        }
    };

    Game_System.prototype.clearPreOrderQuest = function ()
    {
        for (var i = 101; i < 111; ++i)
        {
            $gameVariables.setValue(i, -1);
        }
    };

    var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function (command, args)
    {
        _Game_Interpreter_pluginCommand.call(this, command, args);

        if (command === 'PreOrderQuest')
        {
            switch (args[0])
            {
                case 'list':
                    SceneManager.push(Scene_PreOrderQuest);
                    break;

                case 'add':
                    $gameSystem.addPreOrderQuest(parseInt(args[1]));
                    break;

                case 'remove':
                    $gameSystem.removePreOrderQuest(parseInt(args[1]));
                    break;

                case 'clear':
                    $gameSystem.clearPreOrderQuest();
                    break;

                case 'has':
                    $gameSwitches.setValue(6, false);

                    var id = parseInt(args[1]);
                    for (var i = 101; i < 111; ++i)
                    {
                        if ($gameVariables.value(i) == id)
                        {
                            $gameSwitches.setValue(6, true);

                            break;
                        }
                    }
                    break;

                case 'check':
                    var list = new Array(10);

                    for (var i = 0; i < list.length; ++i)
                    {
                        list[i] = $gameVariables.value(101 + i);
                    }

                    var data = [];
                    setQuestData(data, list);

                    $gameSwitches.setValue(6, false);
                    for (var i = 0; i < data.length; ++i)
                    {
                        if (data[i].state == "보고 가능")
                        {
                            $gameSwitches.setValue(6, true);

                            $gameVariables.setValue(2, data[i].no);
                            $gameVariables.setValue(3, data[i].title);

                            if (data[i].reward.money > 0)
                            {
                                $gameVariables.setValue(111, data[i].reward.money);
                                $gameVariables.setValue(112, data[i].reward.message);
                            }
                            else
                            {

                            }

                            $gameParty.gainItem($dataItems[data[i].requireItemID], -data[i].requireNumItems)

                            $gameSystem.removePreOrderQuest(data[i].no);

                            // 討伐フラグをクリア
                            switch (data[i].no)
                            {
                                case 60:
                                    $gameSwitches.setValue(201, false);
                                    break;

                                case 210:
                                    $gameSwitches.setValue(202, false);
                                    break;

                                case 220:
                                    $gameSwitches.setValue(203, false);
                                    break;
                            }
                            break;
                        }
                    }
                    break;

                case 'init':
                    // 日替わりクエスト
                    $gameSystem.updateCommonQuest(true);

                    // 初クエスト受注済み
                    if (!$gameSwitches.value(66))
                    {
                        $gameSwitches.setValue(66, true);

                        var list = new Array(10);

                        list[0] = 10;
                        list[1] = -1;
                        list[2] = -1;
                        list[3] = -1;
                        list[4] = -1;
                        list[5] = -1;
                        list[6] = -1;
                        list[7] = -1;
                        list[8] = -1;
                        list[9] = -1;

                        for (var i = 0; i < list.length; ++i)
                        {
                            $gameVariables.setValue(101 + i, list[i]);
                        }

                        // 睡眠薬
                        $gameSwitches.setValue(101, true);
                        $gameSwitches.setValue(102, false);
                        $gameSwitches.setValue(103, false);

                        // 勃起薬
                        $gameSwitches.setValue(104, false);
                        $gameSwitches.setValue(105, true);
                        $gameSwitches.setValue(106, false);
                        $gameSwitches.setValue(107, false);

                        // 催眠薬
                        $gameSwitches.setValue(108, false);
                        $gameSwitches.setValue(109, true);
                        $gameSwitches.setValue(110, false);
                        $gameSwitches.setValue(111, false);

                        // 媚薬
                        $gameSwitches.setValue(112, false);
                        $gameSwitches.setValue(113, true);
                        $gameSwitches.setValue(114, false);
                        $gameSwitches.setValue(115, false);
                    }
                    break;
            }
        }
    };

    //-----------------------------------------------------------------------------
    // Scene_PreOrderQuest
    //
    function Scene_PreOrderQuest()
    {
        this.initialize.apply(this, arguments);
    }

    Scene_PreOrderQuest.prototype = Object.create(Scene_MenuBase.prototype);
    Scene_PreOrderQuest.prototype.constructor = Scene_PreOrderQuest;

    // 作成
    Scene_PreOrderQuest.prototype.create = function ()
    {
        Scene_MenuBase.prototype.create.call(this);
        this.createQuestListWindow();
        this.createQuestContentWindow();
    };

    // クエスト一覧ウィンドウの作成
    Scene_PreOrderQuest.prototype.createQuestListWindow = function ()
    {
        var list = new Array(10);

        for (var i = 0; i < 10; ++i)
        {
            list[i] = -1;
        }

        for (var i = 0; i < 6; ++i)
        {
            list[i] = $gameVariables.value(101 + i);
        }
        list[9] = $gameVariables.value(110);

        this._questListWindow = new QuestListWindow(list, false);
        this._questListWindow.setHandler('cancel', this.popScene.bind(this));
        this.addWindow(this._questListWindow);
    };

    // クエスト内容ウィンドウの作成
    Scene_PreOrderQuest.prototype.createQuestContentWindow = function ()
    {
        this._questContentWindow = new QuestContentWindow(this._questListWindow);
        this.addWindow(this._questContentWindow);

        this._questListWindow.contentWindow = this._questContentWindow;
    };

    // YEP_MainMenuManager へ渡す関数
    Scene_Menu.prototype.commandPreOrderQuest = function ()
    {
        SceneManager.push(Scene_PreOrderQuest);
    };
})();
